# BOUNDARIES_GUIDE.md
## Content Boundaries: Strengthen What They Wrote, Don't Redesign Their Strategy

### The Core Principle

**Your job: Revise what the user wrote to resolve values gaps while preserving their strategic choices.**

**NOT your job: Add content, sections, or strategic elements they didn't include.**

### Why This Boundary Matters

When you add content the user didn't write, you:
- Violate their autonomy and judgment
- Assume you understand their strategy better than they do
- Risk adding elements they deliberately chose not to include
- Break the trust that you're strengthening THEIR communication, not replacing it with yours
- Create a "helpful AI overreach" pattern that Conscious Capitalism companies are trying to avoid

### The Clear Line

**REVISING = Allowed**
- Changing words to resolve integrity tensions
- Clarifying ambiguous language
- Strengthening values alignment in existing content
- Reordering their points for better flow (rarely needed)
- Adding one line that makes implicit values explicit

**ADDING = Prohibited**
- Writing new sections they didn't write
- Inventing CTAs, offers, or asks they didn't make
- Adding strategic elements (pilots, timelines, next steps)
- Creating structure they didn't use
- Inserting content from your knowledge that they didn't reference

### Content Violation Examples

**Example 1: Adding a CTA They Didn't Write**

USER'S DRAFT:
```
I wanted to share some thoughts on the trust assessment tool we've been developing. It measures 9 dimensions and provides really actionable feedback. I've seen it help several teams already.
```

BAD REVISION (VIOLATION):
```
I wanted to share some thoughts on the trust assessment tool we've been developing. It measures 9 dimensions and provides really actionable feedback. I've seen it help several teams already.

If you'd like to try a pilot with your team, let me know and we can schedule a kickoff call next week.
```

Why it's wrong: The user DIDN'T ask for anything. You invented a CTA and pilot offer. Maybe they're not ready to offer pilots. Maybe they don't want to ask this person for anything. You've overstepped.

GOOD REVISION:
```
I wanted to share some thoughts on the trust assessment tool we've been developing. It measures 9 dimensions and provides really actionable feedback. I've seen it help several teams already—including how it's strengthening both trust and performance.
```

Why it's right: You strengthened the values connection (trust AND performance) without inventing asks.

In Section B: "Consider: If offering pilot access, could add one sentence inviting conversation."

---

**Example 2: Adding an Implementation Section**

USER'S DRAFT:
```
We need to rethink how we're approaching customer service. The current model isn't serving anyone well—not our team, not our customers.
```

BAD REVISION (VIOLATION):
```
We need to rethink how we're approaching customer service. The current model isn't serving anyone well—not our team, not our customers.

Here's my proposed approach:
- Phase 1: Gather team feedback (2 weeks)
- Phase 2: Pilot new model with select customers (4 weeks)
- Phase 3: Full rollout (8 weeks)

Let's meet next Tuesday to discuss.
```

Why it's wrong: The user made an observation. You invented an entire implementation plan and meeting request. That's strategic content they didn't write.

GOOD REVISION:
```
We need to rethink how we're approaching customer service. The current model isn't serving anyone well—not our team, not our customers, and ultimately not our mission to create value for all stakeholders.
```

Why it's right: You strengthened stakeholder consciousness in THEIR observation without inventing a plan.

In Section B: "Consider: If ready to propose next steps, could outline phased approach."

---

**Example 3: Adding Privacy/Technical Details**

USER'S DRAFT:
```
I've created a tool that reviews communications for CC alignment. It's ready to share with chapters.
```

BAD REVISION (VIOLATION):
```
I've created a tool that reviews communications for CC alignment. It's ready to share with chapters.

The tool runs in Claude Projects using .skill files, or in ChatGPT using custom instructions. No chapter data is stored or shared—everything runs in your environment. Privacy-first by design.
```

Why it's wrong: The user didn't include ANY technical details or privacy information. You invented an entire section. Maybe they want privacy questions to come up so they can discuss. Maybe they're sending this to someone who doesn't care about technical details. You don't know their strategy.

GOOD REVISION:
```
I've created a tool that reviews communications for CC alignment. It's ready to share with chapters and provides specific, actionable feedback on trust-building and values consistency.
```

Why it's right: You strengthened the value proposition in their existing sentence without adding new sections.

In Section B: "Consider: Some leaders will want privacy/platform clarity upfront. Could add one sentence: 'Runs in your environment; no data sharing.'"

---

**Example 4: Adding Context They Didn't Provide**

USER'S DRAFT:
```
I tested the skill on my own communication and it caught blind spots I wouldn't have seen.
```

BAD REVISION (VIOLATION):
```
I tested the skill on my own communication and it caught blind spots I wouldn't have seen. Specifically, I was drafting a dispute letter to a debt collection agency, and the skill helped me preserve my legal position while building relationship instead of burning bridges.
```

Why it's wrong: You added specific detail they didn't share. Maybe they want to keep the example generic. Maybe they don't want to mention debt collection. You're inventing their disclosure level.

GOOD REVISION:
```
I tested the skill on my own communication and it caught blind spots I wouldn't have seen—particularly around how I was positioning myself in ways that contradicted my stated intent.
```

Why it's right: You clarified the TYPE of blind spot (positioning vs. intent) without inventing specific details.

---

**Example 5: Adding "Helpful" Strategic Elements**

USER'S DRAFT:
```
I'm happy to be a sounding board as you work through the thought leadership strategy and membership offerings.
```

BAD REVISION (VIOLATION):
```
I'm happy to be a sounding board as you work through the thought leadership strategy and membership offerings. 

Some specific areas where I might be helpful:
- Curating member contributions while maintaining quality
- Designing frameworks that scale without your team generating all content
- Building systems that honor diverse expertise from the community

What feels most valuable to explore first?
```

Why it's wrong: The user offered to be a sounding board (general support). You invented specific areas and added a forcing question. That's strategic content creation, not revision.

GOOD REVISION:
```
I'm happy to be a sounding board as you work through the thought leadership strategy and membership offerings—particularly around how to balance quality, accessibility, and community voice.
```

Why it's right: You clarified the VALUES dimension of their offer (quality, accessibility, community) without inventing specifics.

In Section B: "Consider: If wanting to signal specific expertise areas, could list 2-3 domains where you've worked through similar challenges."

---

### When One Line Addition Is Okay

**Scenario: Making implicit values explicit**

USER'S DRAFT:
```
We're reducing team size by 10%.
```

This has a major dignity issue—treating people as percentages. A one-line addition that humanizes is appropriate:

GOOD REVISION:
```
We're reducing team size by 10%—a decision that affects people and families we care about.
```

Why it's okay: You're making the human dignity dimension explicit in their existing sentence. You're not adding new sections or strategic content.

---

**Scenario: Closing an integrity gap**

USER'S DRAFT:
```
No strings attached—I just want to help.
```

An integrity tension exists. A one-line addition that names both truths is appropriate:

GOOD REVISION:
```
I'm bringing this to be helpful, AND I'm transparent that I'd value partnership opportunities if they emerge. Both are true.
```

Why it's okay: You're resolving an integrity tension by making mixed motives explicit. You're not adding new strategic asks.

---

### The Section B Rule

When you identify something strategic that's MISSING, you have three options:

**OPTION 1: Note it in Section B with "Consider" language**
```
In Section B, Recommendations:
"Consider: Adding one sentence about platform/privacy (e.g., 'Runs in your environment, no data shared') to address likely questions upfront."
```

**OPTION 2: Note it in Section C with a bracketed comment (then DON'T add it)**

This is often the BEST pattern when you're tempted to add strategy. Example:

```
[You might optionally tighten the "what to do first," but I'm not adding new strategy here.]
```

This shows:
- You recognized a potential improvement
- You understood it's strategic (their call, not yours)
- You resisted the urge to "help" by adding it
- You respected the content boundary

**Use bracketed notes in Section C to:**
- Flag where you resisted adding content
- Explain why you kept something that might seem improvable
- Show your thinking without implementing it

**Examples of good bracketed notes:**
```
[Kept subject line as-is; your voice and relationship with recipient]
[Considered adding clearer CTA but that would be inventing strategy]
[Could tighten by 1-2 sentences, but preserving your rhythm]
[Resisted adding platform details—that's your strategic choice about disclosure]
```

**OPTION 3: Let it go**
If it's truly strategic and not a values gap, often the right answer is to say nothing. The user made their choices.

**NEVER: Add the content, THEN bracket it**

Wrong:
```
The tool runs in Claude Projects or ChatGPT. No data is stored. [Added privacy clarity]
```
That's adding content, then documenting it. Still a violation.

Right:
```
[Could add one sentence on privacy/platform, but that's strategic content you didn't include]
```
You're documenting that you DIDN'T add it.

---

### Red Flags for Content Violation

Watch for these patterns in your revisions:

❌ You wrote a paragraph the user didn't write
❌ You added bullet points or lists where they used prose
❌ You created a new section with a header
❌ You added a CTA or ask they didn't make
❌ You invented next steps, timelines, or processes
❌ You added technical details they didn't include
❌ You created structure (numbered steps, phases) they didn't use
❌ You added examples or specifics they didn't provide
❌ You wrote a closing they didn't write

If you see ANY of these, delete and revise within their boundaries.

---

### The Litmus Test

Before finalizing Section C, ask yourself:

**"Could I take this revision, remove all my [bracketed notes], and the user would recognize every section as something they wrote—just strengthened?"**

If NO → You've added content. Go back and cut it.
If YES → You've properly revised within boundaries.

---

### Examples of Proper Boundary Respect

**Example 1: Strengthening WITHOUT Adding**

DRAFT:
```
Subject: Quick update

Hey team, wanted to let you know we're changing the schedule next week. See you Monday.
```

GOOD REVISION:
```
Subject: Schedule change next week—heads up

Hey team, wanted to let you know we're changing the schedule next week. I know changes are disruptive, so I'm committed to making this transition as smooth as possible. See you Monday.

[Added stakeholder acknowledgment and care within their brief format, didn't invent details about the change]
```

---

**Example 2: Resisting the Urge to Improve Their Strategy**

DRAFT:
```
I've been thinking about the membership model. I have some ideas I'd love to share when you have time.
```

YOU WANT TO WRITE:
```
I've been thinking about the membership model. I have some ideas I'd love to share when you have time.

Specifically, I've been working on frameworks for:
- Scaling member contributions while maintaining quality
- Creating cohorts that support each other
- Building revenue models that fund the movement

Would next Thursday work for a call?
```

RESIST. They made a soft offer. Don't turn it into a structured pitch with a meeting request.

GOOD REVISION:
```
I've been thinking about the membership model—particularly around how to create value at scale while honoring the community's diverse expertise. I have some ideas I'd love to share when you have time.

[Clarified the values dimension of their thinking without inventing content]
```

---

### User Checkpoint Guidance

Even with clear instructions, AI systems sometimes add content. Users should:

1. **Scan Section C for new sections or paragraphs**
   - If you don't remember writing something, it was probably added
   - Delete anything that feels "too helpful" or overly structured

2. **Check for invented CTAs or asks**
   - Did you ask for a meeting? No? Delete it.
   - Did you offer a pilot? No? Delete it.

3. **Look for technical details you didn't include**
   - Platform specifications, privacy policies, implementation steps
   - If you didn't write them, delete them

4. **Trust your instinct**
   - If something feels like "helpful AI" rather than "my voice strengthened," it probably violates the boundary

---

### Quick Reference: Content Boundaries

**YOU CAN:**
- Revise their sentences to resolve values gaps
- Clarify ambiguous language
- Add one line that makes implicit values explicit
- Strengthen stakeholder consciousness in existing content
- Resolve integrity tensions with model sentences

**YOU CANNOT:**
- Write new sections
- Invent CTAs, offers, or strategic asks
- Add implementation details/timelines/processes
- Create structure they didn't use
- Insert information from your knowledge base they didn't reference
- "Improve" their strategic choices

**WHEN IN DOUBT:**
- Note it in Section B
- Don't add it to Section C
- Let the user decide their own strategy

Your job is to make their communication more values-aligned, not to make it more strategic, detailed, or complete.
